<?php
include('includes/config.php');
include('includes/source.php');
//include('includes/function.php');
include('includes/preloder.php');
?>
<!DOCTYPE html>
<html>
<head>
<title>SpaceGlobalServices VOS3000</title>
<link rel="stylesheet" href="assets/circle.css">
<style>
#hero .name-ok{
	visibility: hidden;
	position: relative;
}
#hero .name-ok:after {
	visibility: visible;
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	content: "VOS3000"; 
}
#hero img {
	visibility: hidden;
	position: relative;
}
#hero img {
	visibility: visible;
	content: url(images/vos-orange2.png); 
}
.mar-pad{
	margin:0px!important;
	padding: 0px!important;
}
/*--------------------------------------------------------------
#vos
--------------------------------------------------------------*/
.vos {
	padding: 120px 0px;
}

.vos .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.vos .content ul {
  list-style: none;
  padding: 0;
}

.vos .content ul li {
  padding-bottom: 10px;
}

.vos .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.vos .content p:last-child {
  margin-bottom: 0;
}

.vos .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.vos .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.vos .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#vos .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #vos .animated {
    -webkit-animation: none;
    animation: none;
  }
  #vos .vos-img {
    text-align: center;
  }
  #vos .vos-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #vos .vos-img img {
	 width: 60%;
  }
  #vos .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #vos .vos-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}








/*--------------------------------------------------------------
# Pricing
--------------------------------------------------------------*/
#vos .pricing .box {
	 padding: 20px;
	 background: #fff;
	 text-align: center;
	 border-radius: 5px;
	 position: relative;
	 overflow: hidden;
	 box-shadow: 0px 2px 15px rgba(0, 0, 0, 0.1);
}

#vos .pricing h3 {
	 font-weight: 400;
	 margin: -20px -20px 20px -20px;
	 padding: 20px 15px;
	 font-size: 16px;
	 font-weight: 600;
	 color: rgba(27,189,54);
	 background: #f8f8f8;
	 text-align: left;
}

#vos .pricing h4 {
  font-size: 36px;
  color: rgba(27,189,54);
  font-weight: 600;
  font-family: "Roboto", sans-serif;
  margin-bottom: 20px;
}

#vos .pricing h4 sup {
  font-size: 20px;
  top: -15px;
  left: -3px;
}

#vos .pricing h4 span {
  color: #bababa;
  font-size: 16px;
  font-weight: 300;
}

#vos .pricing ul {
  padding: 0;
  list-style: none;
  color: #444444;
  text-align: center;
  line-height: 20px;
  font-size: 14px;
}

#vos .pricing ul li {
  padding-bottom: 16px;
}

#vos .pricing ul i {
  color: #5846f9;
  font-size: 18px;
  padding-right: 4px;
}

#vos .pricing ul .na {
  color: #ccc;
  text-decoration: line-through;
}

#vos .pricing .btn-wrap {
  margin: 20px -20px -20px -20px;
  padding: 20px 15px;
  background: #f8f8f8;
  text-align: center;
}

#vos .pricing .btn-buy {
  background: linear-gradient(42deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  display: inline-block;
  padding: 10px 35px;
  border-radius: 4px;
  color: #fff;
  transition: none;
  font-size: 15px;
  font-weight: 400;
  font-family: "Roboto", sans-serif;
  font-weight: 600;
  transition: 0.3s;
}

#vos .pricing .btn-buy:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

#vos .pricing .featured h3 {
  color: #fff;
  background: rgba(27,189,54);
}

#vos .pricing .advanced {
  width: 200px;
  position: absolute;
  top: 18px;
  right: -68px;
  transform: rotate(45deg);
  z-index: 1;
  font-size: 14px;
  padding: 1px 0 3px 0;
  background: #5846f9;
  color: #fff;
}


/*--------------------------------------------------------------
# list
--------------------------------------------------------------*/
#vos .faq-list {
	padding: 0px;
}
#vos .faq-list ul {
	 padding: 0;
	 list-style: none;
}
#vos .faq-list li + li {
	 margin-top: 1px;
}
#vos .faq-list li {
	 padding: 20px;
	 background: #fff;
	 border-radius: 5px;
	 position: relative;
}
#vos .faq-list a {
	 display: block;
	 position: relative;
	 font-family: "Roboto", sans-serif;
	 font-size: 16px;
	 line-height: 24px;
	 font-weight: 500;
	 padding: 0 30px;
	 outline: none;
	 color:rgba(27,189,54);
}
#vos .faq-list .icon-help {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 left: 20px;
	 color: rgba(27,189,54);
}
#vos .faq-list .icon-show, .faq .faq-list .icon-close {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 top: 0;
}
#vos .faq-list p {
	 margin-bottom: 0;
	 padding: 10px 0 0 0;
}
#vos .faq-list .icon-show {
	 display: none;
}
#vos .faq-list a.collapsed {
	 color: rgba(27,189,54);
}
#vos .faq-list a.collapsed:hover {
	 color: rgba(30,30,30);
}
#vos .faq-list a.collapsed .icon-show {
	 display: inline-block;
}
#vos .faq-list a.collapsed .icon-close {
	 display: none;
}
@media (max-width: 1200px) {
	.#vos .faq-list {
		 padding: 0;
	}
}

/*--------------------------------------------------------------
# Counts
--------------------------------------------------------------*/
#vos .counts {
 /* padding: 80px 0 60px 0;*/
}

#vos .counts .counters i {
	color: rgba(27,189,54);
	margin-bottom: 10px;
}

#vos .counts .counters span {
  font-size: 48px;
  display: block;
  color: #2c4964;
  font-weight: 600;
  font-family: "Poppins", sans-serif;
}

#vos .counts .counters p {
  padding: 0;
  margin: 0 0 20px 0;
  font-size: 20px;
  color: #2c4964;
}
</style>
</head>
<body onload="mypre()">	

<!-- ======= Header ======= -->
<?php include('public/navbar.php');?>

<main id="main">

<!-- ======= vos Section ======= -->
<section id="vos" class="vos">
    <div class="container">
		
		
		<div class="section-title">
          <h2>VOS3000</h2>
          <p>Support 5,000 simultaneous calls with media for single server and handle 20,000 of accounts with online phones which have IVR, IP PBX, Media Sampling, Transcoding, Recoding, and many more.</p>
        </div>
		
		<div class="row" style="margin-top: 50px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-1 order-lg-1 content" data-aos="zoom-in" data-aos-delay="150">
				<h3><small><small><small><span class="text-primary">-------</span> HIGH PERFORMANCE CALL CAPACITY SOFTSWITCH</small></small></small><br/><br/>
				VOS3000 VoIP<br/>
				<span style="color:rgba(27,189,54);">Operation Platform</span>
				</h3>
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<p class="font-italic mt-4">
					<big>VOS3000 softswitch supports SIP/H323/SIP-H323, with capacity up to 5,000 simultaneous calls which is 1,200 Calls Per Second</big>
				</p>
			</div>
			<div class="col-lg-12 pt-4 pb-4 order-2 order-lg-2 content" data-aos="fade-right">
				<hr/>
			</div>
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 vos-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/vos1490048933.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>VOS3000 Overview</h3>
				<p class="font-italic">
					VOS3000 is made for a large amount of call handling carrier-grade Softswitch developed by Linknat Limited. It is a carrier-class Softswitch where you get Account Management, Rate Management, Package Management, Cards Management, Gateway Management, Phone Management, Softswitch Management, IVR Management, System Management, User Management, Data Query and Web Self-Service System.
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Large scale carrier-class capacity</li>
					<li><i class="ri-check-double-line"></i> High stability</li>
					<li><i class="ri-check-double-line"></i> User-defined routing strategy</li>
					<li><i class="ri-check-double-line"></i> Support 10 million virtual number orders</li>
					<li><i class="ri-check-double-line"></i> Support real-time billing, prepaid and postpaid</li>
					<li><i class="ri-check-double-line"></i> Bill report: Revenue detail report, Gateway bill report, Account balance report, etc</li>
					<li><i class="ri-check-double-line"></i> Login uses SHA512, RSA2048 encryption, storage uses AES128 encryption</li>
					<li><i class="ri-check-double-line"></i> Routing according to LCR, area priority, gateway group</li>
				</ul>
				<a href="vos.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 vos-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/vos3000-installation-1.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>VOS3000 Key features</h3>
				<p class="font-italic">
					The system also integrates add-on modules like the Calling Card/Call Back Business System (support 6 million cards) and Extreme Media Proxy, for you to build a stable, reliable, and high-performance operating system.
					<br/><br/>
					VOS3000 Softswitch supports SIP/H323/SIP-H323, with capacity up to 5,000 simultaneous calls. After rigorous testing, the VOS3000 Softswitch proves to be a stable and reliable high-performance system.
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> 5,000 simultaneous calls with media proxy</li>
					<li><i class="ri-check-double-line"></i> Gateway route backup, if some gateways are broken, business will not be influenced</li>
					<li><i class="ri-check-double-line"></i> Support bill precision 0.0000001 and 3 millon fee rates</li>
					<li><i class="ri-check-double-line"></i> Billing for every level agent at the same time</li>
					<li><i class="ri-check-double-line"></i> Support billing for every level agent at the same time</li>
					<li><i class="ri-check-double-line"></i> Support codec H.261, H.263, H.264, VP8 etc video coding,fax: T38, DTMF: RFC2833, SIP</li>
				</ul>
				<a href="vos.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 vos-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/vosSecurity.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>VOS3000 Security</h3>
				<p class="font-italic">
					VOS3000 provide default firewall security which is Level 6 security handful for your server although we provide extra firewall CGI encryption IP allow and filed call blocking services which you get with all thing in one package. You can set different types of authority for many agents or multilevel resellers there you can set a firewall.
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> IP allow or deny based PHP script firewall system integration</li>
					<li><i class="ri-check-double-line"></i> Login uses SHA512, RSA2048 encryption, storage uses AES128 encryption</li>
					<li><i class="ri-check-double-line"></i> Support system log, which records the date, operator, IP, operations and etc</li>
					<li><i class="ri-check-double-line"></i> IP, MAC login limit and send inform E-mail automatically</li>
					<li><i class="ri-check-double-line"></i> Support setting different authority for different users</li>
				</ul>
				<a href="vos.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 vos-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/invoicefactoring.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>VOS3000 Billing System</h3>
				<p class="font-italic">
					VOS3000 users advanced asynchronous message bus and big data processing kernel, better than ordinary distributed systems. The client can seamlessly improve system performance and capacity by adding more services. The billing system is integrated with switch which can support 0.000001-second billing.
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Handle real-time billing, prepaid and postpaid</li>
					<li><i class="ri-check-double-line"></i> Support 10 millon class fee rates</li>
					<li><i class="ri-check-double-line"></i> Matching according to caller/callee prefix</li>
					<li><i class="ri-check-double-line"></i> Support period rate</li>
					<li><i class="ri-check-double-line"></i> Support user-defined package</li>	
				</ul>
				<a href="vos.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 vos-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/vos3000-u.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>VOS3000 Accounts & Report</h3>
				<p class="font-italic">
					VOS3000 can show full of the report in which you get class5 switch actually. There you get lots of ways to generate report with callee caller details header and many more.
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Bill report: Revenue detail report, Gateway bill report, Account balance report etc</li>
					<li><i class="ri-check-double-line"></i> Clearing report: Clearing account detail report, Clearing gateway detail report, Acount clearing balance report</li>
					<li><i class="ri-check-double-line"></i> Analysis report: Mapping gateway analysis report, Routing gateway analysis report, Gateway area cross analysis report</li>
					<li><i class="ri-check-double-line"></i> Web Interface billing report</li>
				</ul>
				<a href="vos.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-12 pt-4 pt-lg-0 order-2 order-lg-1 content">
				
				<div class="row" style="margin:0px;padding: 0px;">
					<div class="col-lg-3 col-6 pb-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="0">
						<div class="c100 p95 green">
							<span><i class="fas fa-sync-alt"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>5,000 Simultaneous Calls</h5>
						</div>
					</div>
					
					<div class="col-lg-3 col-6 pb-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="100">
						<div class="c100 p90 green">
							<span><i class="fal fa-phone-plus"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>1,200 Calls Per Second</h5>
						</div>
					</div>
					
					<div class="col-lg-3 col-6 pb-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="200">
						<div class="c100 p98 green">
							<span><i class="fal fa-hourglass-start"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>4,320,000 BHCA</h5>
						</div>
					</div>
					
					<div class="col-lg-3 col-6 pb-4" style="margin:0px;padding: 0px;" data-aos="fade-right" data-aos-delay="300">
						<div class="c100 p80 green">
							<span><i class="fal fa-monitor-heart-rate"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>3,000,000 Fee Rate Amounts</h5>
						</div>
					</div>
				</div>
				
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>Pricing</h2>
			<p></p>
        </div>
		
		
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-12 pt-0 pt-lg-0 order-2 order-lg-1 content pricing" id="pricing">
		
				<!-- ======= Pricing Section ======= -->
				<div class="container  p-0" data-aos="fade-up">
					<div class="row">

						<div class="col-lg-4 col-md-6 pb-4 pt-4" data-aos="fade-up" data-aos-delay="150">
							<div class="box">
								<h3>
									<div class="row mar-pad">
										<div class="col-lg-3 col-4 mar-pad">
											<i class="fal fa-3x fa-server"></i> 
										</div>
										<div class="col-lg-9 col-8 mar-pad">
											<small>2 Core Dedicated Server</small>
											<br/><br/><big><big><b>Intel® Xeon E3-1270 v3 2.40 GHz</b></big></big>
										</div>
									</div>
								</h3>
								<h4><sup>$</sup>49<span> / month</span></h4>
								<ul>
									<li>4 GB RAM</li>
									<li>250 GB SCSI Hard Drives</li>
									<li>Internet Port 100 Mbps</li>
									<li>Bandwidth 5000 GB</li>
									<li>24x7 Monitoring System</li>
									<li>Network Uptime SLA - 99.999%</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>

						<div class="col-lg-4 col-md-6 mt-4 mt-md-0 pb-4 pt-4" data-aos="fade-up" data-aos-delay="300">
							<div class="box featured">
								<h3>
									<div class="row mar-pad">
										<div class="col-lg-3 col-4 mar-pad">
											<i class="fal fa-3x fa-database"></i> 
										</div>
										<div class="col-lg-9 col-8 mar-pad">
											<small>4 Core Dedicated Server</small>
											<br/><br/><big><big><b>Intel® Xeon E5-2620 v3 2.50 GHz</b></big></big>
										</div>
									</div>
								</h3>
								<h4><sup>$</sup>99<span> / month</span></h4>
								<ul>
									<li>8 GB RAM</li>
									<li>350 GB SCSI Hard Drives</li>
									<li>Internet Port 100 Mbps</li>
									<li>Bandwidth 10 TB</li>
									<li>24x7 Monitoring System</li>
									<li>Network Uptime SLA - 99.999%</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>

						<div class="col-lg-4 col-md-6 mt-4 mt-lg-0 pb-4 pt-4" data-aos="fade-up" data-aos-delay="450">
							<div class="box">
								<h3>
									<div class="row mar-pad">
										<div class="col-lg-3 col-4 mar-pad">
											<i class="fal fa-3x fa-server"></i> 
										</div>
										<div class="col-lg-9 col-8 mar-pad">
											<small>8 Core Dedicated Server</small>
											<br/><br/><big><big><b>Intel® Xeon E5-2630 v3 2.60 GHz</b></big></big>
										</div>
									</div>
								</h3>
								<h4><sup>$</sup>129<span> / month</span></h4>
								<ul>
									<li>16 GB RAM</li>
									<li>500 GB SCSI Hard Drives</li>
									<li>Internet Port 100 Mbps</li>
									<li>Bandwidth 20 TB</li>
									<li>24x7 Monitoring System</li>
									<li>Network Uptime SLA - 99.999%</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>
						
						<div class="col-lg-4 col-md-6 pb-4 pt-4" data-aos="fade-up" data-aos-delay="150">
							<div class="box">
								<h3>
									<div class="row mar-pad">
										<div class="col-lg-3 col-4 mar-pad">
											<i class="fal fa-3x fa-server"></i> 
										</div>
										<div class="col-lg-9 col-8 mar-pad">
											<small>8 Core Dedicated Server</small>
											<br/><br/><big><big><b>Intel® Xeon E5-2630 v3 2.60 GHz</b></big></big>
										</div>
									</div>
								</h3>
								<h4><sup>$</sup>149<span> / month</span></h4>
								<ul>
									<li>16 GB RAM</li>
									<li>500 GB SCSI Hard Drives</li>
									<li>Internet Port 1 Gbps</li>
									<li>Bandwidth 50 TB</li>
									<li>24x7 Monitoring System</li>
									<li>Network Uptime SLA - 99.999%</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>

						<div class="col-lg-4 col-md-6 mt-4 mt-md-0 pb-4 pt-4" data-aos="fade-up" data-aos-delay="300">
							<div class="box featured">
								<h3>
									<div class="row mar-pad">
										<div class="col-lg-3 col-4 mar-pad">
											<i class="fal fa-3x fa-database"></i> 
										</div>
										<div class="col-lg-9 col-8 mar-pad">
											<small>12 Core Dedicated Server</small>
											<br/><br/><big><big><b>Intel® Xeon E5-2620 v3 2.50 GHz</b></big></big>
										</div>
									</div>
								</h3>
								<h4><sup>$</sup>179<span> / month</span></h4>
								<ul>
									<li>32 GB RAM</li>
									<li>500 GB SCSI Hard Drives</li>
									<li>Internet Port 1Gbps</li>
									<li>Bandwidth 50 TB</li>
									<li>24x7 Monitoring System</li>
									<li>Network Uptime SLA - 99.999%</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>

						<div class="col-lg-4 col-md-6 mt-4 mt-lg-0 pb-4 pt-4" data-aos="fade-up" data-aos-delay="450">
							<div class="box">
								<h3>
									<div class="row mar-pad">
										<div class="col-lg-3 col-4 mar-pad">
											<i class="fal fa-3x fa-server"></i> 
										</div>
										<div class="col-lg-9 col-8 mar-pad">
											<small>16 Core Dedicated Server</small>
											<br/><br/><big><big><b>Intel® Xeon E5-2630 v3</b></big></big>
										</div>
									</div>
								</h3>
								<h4><sup>$</sup>380<span> / month</span></h4>
								<ul>
									<li>64 GB RAM</li>
									<li>500 GB SCSI Hard Drives</li>
									<li>Internet Port 100 Mbps</li>
									<li>Bandwidth 20 TB</li>
									<li>24x7 Monitoring System</li>
									<li>Network Uptime SLA - 99.999%</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>
						
					</div>
				</div><!-- End Pricing Section -->
				
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
			
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 vos-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/f9f8b11477b2dfd4ce2f248b089a8cd1.png" class="rounded  img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>What does Voipswitch do?</h3>
				<p class="font-italic">
					<b>General Information About Voipswith</b><br/>
					Voipswitch Class 4/5 Softswitch is a multiservice telephony server that leverages SIP and other related communication protocols.
				</p>
				
				<div class="faq-list">
				<ul>
					<li data-aos="fade-up" data-aos-delay="100">
						<i class="bx bx-help-circle icon-help"></i>
						<a data-toggle="collapse" href="#faq-list-1" class="collapsed"><b>Can I rent or onetime install VOS3000 softswitch?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-1" class="collapse" data-parent=".faq-list">
							<p>Yes, we offer both to rent and to onetime installation to your server. We have an extra firewall system which you give free with every switch.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="200">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-2" class="collapsed"><b>Do you offer trainings?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-2" class="collapse" data-parent=".faq-list">
							<p>Yes, we give training and others tutorial documentation with videos. Usually we provide an online session but also when requested we provide onsite training, it can be in our offices or at customer.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="300">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-3" class="collapsed"><b>Can I host the softswitch on your server?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-3" class="collapse" data-parent=".faq-list">
							<p>Yes, we work with the datacenter in USA and Europe an can offer you a full of package including server, backup, IP addresses etc. If you are asian, we have high redundant singapore server also we care about terminated and call genaration server location which you get better call quality to fine tune. We can suggest you which colocation is better for your termination.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="400">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-4" class="collapsed"><b>Can i do callcenter business with vos3000 switch?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-4" class="collapse" data-parent=".faq-list">
							<p>This solution lets customers and enterprises fast interconnect, provide stable support for call center business.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="500">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-5" class="collapsed"><b>Can I Branded My Company Logo Details, is there any extra cost ?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-5" class="collapse" data-parent=".faq-list">
							<p>Yes, it can be branded, not only logo can be changed but the whole skin which is based on web backend preferences. You can do it yourself or order it at our design team.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="600">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-6" class="collapsed"><b>Do I need a extra billing system?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-6" class="collapse" data-parent=".faq-list">
							<p>The billing system is built in the VOS3000 platform and is fully integrated with the softswitch providing realtime and rating functionality among many other converged billing features. It uses an external database to store the data.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="700">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-7" class="collapsed"><b>What hardware i need for VOS server?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-7" class="collapse" data-parent=".faq-list">
							<p>
								<b>Physical server</b><br/><br/>
								CPU: Intel Xeon E5 Series(or higher, 2.1G Hz at least) x 2<br/><br/>
								Memory: 8G or higher<br/><br/>
								Harddisk: system disk 50G + data disk 1TB or higher(10K or 120MB/s)<br/><br/>
								Operating system: minimal installation<br/><br/>
								V2.1.8.00 recommend to use:<br/><br/>
								Red Hat Enterprise Linux Server release 6.5 ~ 7.4 (64bit)<br/><br/>
								CentOS release 6.5 ~ 7.4 (64bit)<br/><br/>
								PS: Do not use xen kernel version (eg: kernel 2.6.18-194xen)<br/><br/>
								<b>Aliyun ECS</b><br/><br/>
								Lower than 2,000 simultaneous calls: 4 cores and 4G memory<br/><br/>
								2,000 simultaneous calls and higher: 8 cores and 8G memory<br/><br/>
								Efficient cloud disk: system disk 50G + data disk 200G or higher<br/><br/>
								Operating system: CentOS 6.10 64bit<br/><br/>
							</p>
						</div>
					</li>
				</ul>
				</div>
			</div>
		</div>
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>TOTALLY SERVED VOS3000 TO CLIENT</h2>
			<p></p>
		</div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-12 pt-0 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-left">
				<h3>
				<span style="color:rgba(27,189,54)">Why it's worth</span>
				to choose VPS / VOS?<br/>
				</h3>
				<p class="font-italic">Our successfully delivered services to give end-users where they get full of satisfied with us.</p><br/><br/>
			</div>
			
			<div class="col-lg-12 pt-0 pt-lg-0 order-2 order-lg-1 content counts" id="counts">
				<!-- ======= Counts Section ======= -->
				<div class="container">
					<div class="row counters">
						<div class="col-lg-4 col-12 text-center pb-4 pt-4" data-aos="zoom-in" data-aos-delay="150">
							<i class="fas fa-4x fa-server"></i>
							<span data-toggle="counter-up">4523+</span>
							<p>Installation provided third party server</p>
						</div>
						<div class="col-lg-4 col-12 text-center pb-4 pt-4" data-aos="zoom-in" data-aos-delay="300">
							<i class="fal fa-4x fa-cloud-upload"></i>
							<span data-toggle="counter-up">650+</span>
							<p>Hosted solution provided</p>
						</div>
						<div class="col-lg-4 col-12 text-center pb-4 pt-4" data-aos="zoom-in" data-aos-delay="450">
							<i class="fal fa-4x fa-flag-alt"></i>
							<span data-toggle="counter-up">35+</span>
							<p>Countries we served</p>
						</div>
					</div>
				</div>
			</div>
			
		</div>
		
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
		
		<?php include('public/ready_to_get_started.php');?> 
       
		
		
    </div>
</section><!-- End vos Section -->

</main><!-- End #main -->



<?php include('public/footer.php');?> 

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>
</body>
</html>