<?php // 14 ?>
<!DOCTYPE html>
<html>
<head>
<style>
/*--------------------------------------------------------------
#seo
--------------------------------------------------------------*/
.seo {
	padding: 120px 0px 10px 0px;
}

.seo .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.seo .content ul {
  list-style: none;
  padding: 0;
}

.seo .content ul li {
  padding-bottom: 10px;
}

.seo .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.seo .content p:last-child {
  margin-bottom: 0;
}

.seo .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.seo .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.seo .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#seo .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #seo .animated {
    -webkit-animation: none;
    animation: none;
  }
  #seo .seo-img {
    text-align: center;
  }
  #seo .seo-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #seo .seo-img img {
	 width: 60%;
  }
  #seo .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #seo .seo-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}
</style>
</head>
<body>	
<!-- ======= seo Section ======= -->
<section id="seo" class="seo">
    <div class="container">
		
		<div class="section-title">
          <h2>SEO</h2>
          <p>Search engine optimization is the process of improving the quality and quantity of website traffic to a website or a web page from search engines. SEO targets unpaid traffic rather than direct traffic or paid traffic.</p>
        </div>
		
        <div class="row">
			<div class="col-lg-6 order-1 order-lg-1 seo-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/SEO-main.jpg" class="rounded img-fluid animated" alt="" />
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Search Engine Optimization?</h3>
				<p class="font-italic">
					SEO means Search Engine Optimization and is the process used to optimize a website's technical configuration, content relevance and link popularity so its pages can become easily findable, more relevant and popular towards user search queries, and as a consequence, search engines rank them better.
					<br/><br/>
					Search engines recommend SEO efforts that benefit both the user search experience and page’s ranking, by featuring content that fulfills user search needs. This includes the use of relevant keywords in titles, meta descriptions, and headlines (H1), featuring descriptive URLs with keywords rather than strings of numbers, and schema markup to specify the page's content meaning, among other SEO best practices.
				</p>
				<a href="seo.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
			
			<div class="col-lg-12 col-md-12 col-12 pt-4 mt-4 pt-lg-0 order-2 order-lg-2 content">
			
				<div class="row">	
					<div class="col-lg-6 col-md-12 col-12">
						<!--a href="seo.php" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="150">What Is Sip (Session Initiation Protocol)<i class="icofont-long-arrow-right"></i></a-->
					</div>
					<div class="col-lg-6 col-md-12 col-12">
					
					</div>
				</div>
				
			</div>
        </div>

    </div>
</section><!-- End seo Section -->
</body>
</html>