<?php // 13 ?>
<!DOCTYPE html>
<html>
<head>
<style>
/*--------------------------------------------------------------
#digital_marketing
--------------------------------------------------------------*/
.digital_marketing {
	padding: 120px 0px 10px 0px;
}

.digital_marketing .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.digital_marketing .content ul {
  list-style: none;
  padding: 0;
}

.digital_marketing .content ul li {
  padding-bottom: 10px;
}

.digital_marketing .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.digital_marketing .content p:last-child {
  margin-bottom: 0;
}

.digital_marketing .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.digital_marketing .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.digital_marketing .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#digital_marketing .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #digital_marketing .animated {
    -webkit-animation: none;
    animation: none;
  }
  #digital_marketing .digital_marketing-img {
    text-align: center;
  }
  #digital_marketing .digital_marketing-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #digital_marketing .digital_marketing-img img {
	 width: 60%;
  }
  #digital_marketing .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #digital_marketing .digital_marketing-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}
</style>
</head>
<body>	
<!-- ======= digital_marketing Section ======= -->
<section id="digital_marketing" class="digital_marketing">
    <div class="container">
		
		<div class="section-title">
          <h2>Digital Marketing</h2>
          <p>Basically, digital marketing refers to any online marketing efforts or assets. Email marketing, pay-per-click advertising, social media marketing and even blogging are all great examples of digital marketing.</p>
        </div>
		
        <div class="row">
			<div class="col-lg-6 order-1 order-lg-2 digital_marketing-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/digital_marketing-main.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>What is Digital Marketing?</h3>
				<p class="font-italic">
					Any marketing that uses electronic devices to convey promotional messaging and measure its impact. In practice, digital marketing typically refers to marketing campaigns that appear on a computer, phone, tablet, or other device. It can take many forms, including online video, display ads, and social media posts. Digital marketing is often compared to “traditional marketing” such as magazine ads, billboards, and direct mail. Oddly, television is usually lumped in with traditional marketing.
					<br/><br/>
					<b>Digital Marketing Assets</b><br/>
					Almost anything can be a digital marketing asset. It simply needs to be a marketing tool you use online. That being said, many people don’t realize how many digital marketing assets they have at their disposal. Here are just a few examples:
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i>  Your website</li>
					<li><i class="ri-check-double-line"></i>  Branded assets (logos, icons, acronyms, etc)</li>
					<li><i class="ri-check-double-line"></i>  Video content (video ads, product demos, etc)</li>
					<li><i class="ri-check-double-line"></i>  Images (infographics, product shots, company photos, etc)</li>
					<li><i class="ri-check-double-line"></i>  Written content (blog posts, eBooks, product descriptions, testimonials, etc)</li>
					<li><i class="ri-check-double-line"></i>  Online products or tools (SaaS, calculators, interactive content, etc)</li>
					<li><i class="ri-check-double-line"></i>  Reviews</li>
					<li><i class="ri-check-double-line"></i>  Social media pages</li>
				</ul>
				<a href="digital_marketing.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
			
			<div class="col-lg-12 col-md-12 col-12 pt-4 mt-4 pt-lg-0 order-2 order-lg-2 content">
			
				<div class="row">	
					<div class="col-lg-6 col-md-12 col-12">
						<!--a href="digital_marketing.php" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="150">What Is Sip (Session Initiation Protocol)<i class="icofont-long-arrow-right"></i></a-->
					</div>
					<div class="col-lg-6 col-md-12 col-12">
					
					</div>
				</div>
				
			</div>
        </div>

    </div>
</section><!-- End digital_marketing Section -->
</body>
</html>