<?php // 11 ?>
<!DOCTYPE html>
<html>
<head>
<style>
/*--------------------------------------------------------------
#asterisk
--------------------------------------------------------------*/
.asterisk {
	padding: 120px 0px 10px 0px;
}

.asterisk .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.asterisk .content ul {
  list-style: none;
  padding: 0;
}

.asterisk .content ul li {
  padding-bottom: 10px;
}

.asterisk .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.asterisk .content p:last-child {
  margin-bottom: 0;
}

.asterisk .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.asterisk .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.asterisk .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#asterisk .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #asterisk .animated {
    -webkit-animation: none;
    animation: none;
  }
  #asterisk .asterisk-img {
    text-align: center;
  }
  #asterisk .asterisk-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #asterisk .asterisk-img img {
	 width: 60%;
  }
  #asterisk .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #asterisk .asterisk-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}
</style>
</head>
<body>	
<!-- ======= asterisk Section ======= -->
<section id="asterisk" class="asterisk">
    <div class="container">
		
		<div class="section-title">
          <h2>Asterisk</h2>
          <p>Asterisk is an open source framework for building communications applications. Asterisk turns an ordinary computer into a communications server.</p>
        </div>
		
        <div class="row">
			<div class="col-lg-6 order-1 order-lg-1 asterisk-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/asterisk-logo-twitter-share.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Sippy Softswitch Overview?</h3>
				<p class="font-italic">
					Today, there are more than one million Asterisk-based communications systems in use, in more than <b>170 countries.</b> Asterisk is used by almost the entire Fortune <b>1000 list of customers.</b> Most often deployed by system integrators and developers, Asterisk can become the basis for a complete business phone system, or used to enhance or extend an existing system, or to bridge a gap between systems.
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> TDMoE (Time Division Multiplex over Ethernet)</li>
					<li><i class="ri-check-double-line"></i> Allows direct connection of Asterisk PBX</li>
					<li><i class="ri-check-double-line"></i> Zero latency</li>
					<li><i class="ri-check-double-line"></i> Uses commodity Ethernet hardware</li>
					<li><i class="ri-check-double-line"></i> Voice-over IP</li>
					<li><i class="ri-check-double-line"></i> Allows for integration of physically separate installations</li>
					<li><i class="ri-check-double-line"></i> Uses commonly deployed data connections</li>
					<li><i class="ri-check-double-line"></i> Allows a unified dialplan across multiple offices</li>
				</ul>
				<a href="asterisk.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
			
			<div class="col-lg-12 col-md-12 col-12 pt-4 mt-4 pt-lg-0 order-2 order-lg-2 content">
			
				<div class="row">	
					<div class="col-lg-6 col-md-12 col-12">
						<!--a href="asterisk.php" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="150">What Is Sip (Session Initiation Protocol)<i class="icofont-long-arrow-right"></i></a-->
					</div>
					<div class="col-lg-6 col-md-12 col-12">
					
					</div>
				</div>
				
			</div>
        </div>

    </div>
</section><!-- End asterisk Section -->
</body>
</html>