<?php
include('includes/config.php');
include('includes/source.php');
//include('includes/function.php');
include('includes/preloder.php');
?>
<!DOCTYPE html>
<html>
<head>
<title>SpaceGlobalServices PBX Phone System</title>
<link rel="stylesheet" href="assets/circle.css">
<style>
#hero .name-ok{
	visibility: hidden;
	position: relative;
}
#hero .name-ok:after {
	visibility: visible;
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	content: "PBX Phone System"; 
}
#hero img {
	visibility: hidden;
position: relative;
}
#hero img {
	visibility: visible;
	content: url(images/PBX-011.png); 
}
.mar-pad{
	margin:0px!important;
	padding: 0px!important;
}
/*--------------------------------------------------------------
#pbx
--------------------------------------------------------------*/
.pbx {
	padding: 120px 0px;
}

.pbx .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.pbx .content ul {
  list-style: none;
  padding: 0;
}

.pbx .content ul li {
  padding-bottom: 10px;
}

.pbx .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.pbx .content p:last-child {
  margin-bottom: 0;
}

.pbx .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.pbx .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.pbx .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#pbx .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #pbx .animated {
    -webkit-animation: none;
    animation: none;
  }
  #pbx .pbx-img {
    text-align: center;
  }
  #pbx .pbx-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #pbx .pbx-img img {
	 width: 60%;
  }
  #pbx .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #pbx .pbx-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}








/*--------------------------------------------------------------
# Pricing
--------------------------------------------------------------*/
#pbx .pricing .box {
	 padding: 20px;
	 background: #fff;
	 text-align: center;
	 border-radius: 5px;
	 position: relative;
	 overflow: hidden;
	 box-shadow: 0px 2px 15px rgba(0, 0, 0, 0.1);
}

#pbx .pricing h3 {
	 font-weight: 400;
	 margin: -20px -20px 20px -20px;
	 padding: 20px 15px;
	 font-size: 16px;
	 font-weight: 600;
	 color: rgba(27,189,54);
	 background: #f8f8f8;
	 text-align: left;
}

#pbx .pricing h4 {
  font-size: 36px;
  color: rgba(27,189,54);
  font-weight: 600;
  font-family: "Roboto", sans-serif;
  margin-bottom: 20px;
}

#pbx .pricing h4 sup {
  font-size: 20px;
  top: -15px;
  left: -3px;
}

#pbx .pricing h4 span {
  color: #bababa;
  font-size: 16px;
  font-weight: 300;
}

#pbx .pricing ul {
  padding: 0;
  list-style: none;
  color: #444444;
  text-align: center;
  line-height: 20px;
  font-size: 14px;
}

#pbx .pricing ul li {
  padding-bottom: 16px;
}

#pbx .pricing ul i {
  color: #5846f9;
  font-size: 18px;
  padding-right: 4px;
}

#pbx .pricing ul .na {
  color: #ccc;
  text-decoration: line-through;
}

#pbx .pricing .btn-wrap {
  margin: 20px -20px -20px -20px;
  padding: 20px 15px;
  background: #f8f8f8;
  text-align: center;
}

#pbx .pricing .btn-buy {
  background: linear-gradient(42deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  display: inline-block;
  padding: 10px 35px;
  border-radius: 4px;
  color: #fff;
  transition: none;
  font-size: 15px;
  font-weight: 400;
  font-family: "Roboto", sans-serif;
  font-weight: 600;
  transition: 0.3s;
}

#pbx .pricing .btn-buy:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

#pbx .pricing .featured h3 {
  color: #fff;
  background: rgba(27,189,54);
}

#pbx .pricing .advanced {
  width: 200px;
  position: absolute;
  top: 18px;
  right: -68px;
  transform: rotate(45deg);
  z-index: 1;
  font-size: 14px;
  padding: 1px 0 3px 0;
  background: rgba(27,189,54);
  color: #fff;
}


/*--------------------------------------------------------------
# list
--------------------------------------------------------------*/
#pbx .faq-list {
	padding: 0px;
}
#pbx .faq-list ul {
	 padding: 0;
	 list-style: none;
}
#pbx .faq-list li + li {
	 margin-top: 1px;
}
#pbx .faq-list li {
	 padding: 20px;
	 background: #fff;
	 border-radius: 5px;
	 position: relative;
}
#pbx .faq-list a {
	 display: block;
	 position: relative;
	 font-family: "Roboto", sans-serif;
	 font-size: 16px;
	 line-height: 24px;
	 font-weight: 500;
	 padding: 0 30px;
	 outline: none;
	 color:rgba(27,189,54);
}
#pbx .faq-list .icon-help {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 left: 20px;
	 color: rgba(27,189,54);
}
#pbx .faq-list .icon-show, .faq .faq-list .icon-close {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 top: 0;
}
#pbx .faq-list p {
	 margin-bottom: 0;
	 padding: 10px 0 0 0;
}
#pbx .faq-list .icon-show {
	 display: none;
}
#pbx .faq-list a.collapsed {
	 color: rgba(27,189,54);
}
#pbx .faq-list a.collapsed:hover {
	 color: rgba(30,30,30);
}
#pbx .faq-list a.collapsed .icon-show {
	 display: inline-block;
}
#pbx .faq-list a.collapsed .icon-close {
	 display: none;
}
@media (max-width: 1200px) {
	.#pbx .faq-list {
		 padding: 0;
	}
}

/*--------------------------------------------------------------
# Counts
--------------------------------------------------------------*/
#pbx .counts {
 /* padding: 80px 0 60px 0;*/
}

#pbx .counts .counters i {
	color: rgba(27,189,54);
	margin-bottom: 10px;
}

#pbx .counts .counters span {
  font-size: 48px;
  display: block;
  color: #2c4964;
  font-weight: 600;
  font-family: "Poppins", sans-serif;
}

#pbx .counts .counters p {
  padding: 0;
  margin: 0 0 20px 0;
  font-size: 20px;
  color: #2c4964;
}
</style>
</head>
<body onload="mypre()">	

<!-- ======= Header ======= -->
<?php include('public/navbar.php');?>

<main id="main">

<!-- ======= pbx Section ======= -->
<section id="pbx" class="pbx">
    <div class="container">
		
		
		<div class="section-title">
          <h2>PBX Phone System</h2>
          <p>Find out what PBX means, how it works, what problems it solves, and advantages & disadvantages of PBX phone systems (& alternatives).</p>
        </div>

		<div class="row" style="margin-top: 50px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-1 order-lg-1 content" data-aos="zoom-in" data-aos-delay="150">
				<h3><small><small><small><span style="color:rgba(27,189,54)">-------</span> ENTERPRISE GRADE SCALABILITY SOFTSWITCH</small></small></small><br/><br/>
				Is a PBX Phone System the <br/>
				<span style="color:rgba(27,189,54)">Right Choice for your Business</span>
				</h3>
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<p class="font-italic mt-4">
					<big>Find out what PBX means, how it works, what problems it solves, and advantages & disadvantages of PBX phone systems (& alternatives).</big>
				</p>
			</div>
			<div class="col-lg-12 pt-4 pb-4 order-2 order-lg-2 content" data-aos="fade-right">
				<hr/>
			</div>
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/pbx.jpeg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>What is PBX?</h3>
				<p class="font-italic">
					PBX or private branch exchange is a telecommunications device used by businesses to route all the calls made within, to, and from their phone network. A PBX connects a business’ internal phone lines to each other and to the PSTN (Public Switched Telephone Network).
					<br/><br/>
					It has the intelligence to route incoming and outgoing calls based on pre-set rules programmed into it. Each terminating device connected to a PBX is called an “extension” and is assigned a unique (within that network) phone number.
				</p>
				<a href="pbx.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>PBX Phone System</h2>
			<p>Private Branch Exchange phone systems are multi-line phone networks that enable voice communication for businesses over the PSTN. They use circuit switching telephony to send and receive voice messages, which simply means that they convert voice messages to analogue signals and then transmit these signals over the PSTN.</p>
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Components of a PBX phone system.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Components of a PBX phone system</h3>
				<p class="font-italic">
					A PBX phone system has the following components:
					<br/><br/>
					<b>1. Private Branch Exchange Server:</b>This is the main component of PBX phone systems. It handles everything from call routing to voicemail.
					<br/><br/>
					<b>2. Voicemail server:</b> This is where the recorded voice resides for automated greetings, and where all voicemail is stored.
					<br/><br/>
					<b>3. Gateway:</b> This connects your PBX to the PSTN.
					<br/><br/>
					<b>4. Analogue phones:</b> These phones are used by agents to make and receive calls. They are connected to the PBX via phone lines.
					<br/><br/>
					<b>5. Physical wires:</b> These connect the analogue phones to the PBX.
				</p>
				<a href="pbx.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>Why did Businesses Need a PBX?</h2>
			<p>Before PBXs came into the picture, if a business had 50 agents, they needed to buy 50 phone lines. This was undesirable due to the following reasons:</p>
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/c67d31ea-9900-4627-bad6-948dfc091060-5e431be45447e.jpeg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Expensive setup</h3>
				<p class="font-italic">
					It was expensive to buy separate phone lines. Additionally, the businesses incurred high costs even for internal communication.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/img_resources_could_voip.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Waste of resources</h3>
				<p class="font-italic">
					It led to a waste of resources. It’s highly unlikely that all 50 agents will be speaking to customers simultaneously.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 70px;">
		</div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 text-center offset-lg-3 content" data-aos="fade-right">
				<a href="pbx.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
		</div>
		
		
		
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/virtual+pbx+1.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Advantages of using a PBX Phone System</h3>
				<p class="font-italic">
					<b><h2><i class="fas fa-rupee-sign"></i></h2> Free internal communication</b><br/>
					One of the primary advantages of a PBX phone system is the fact that they share a trunk line with internal phones. This results in free internal communication.
					<br/><br/>
					<b><h2><i class="fas fa-phone-alt"></i></h2> Lesser number of phone lines required</b><br/>
					Reduces the number of phone lines that need to be purchased. For 50 agents, businesses need to buy only 7-10 phone lines since all communication is optimized by the PBX.
					<br/><br/>
					<b><h2><i class="fal fa-stopwatch"></i></h2> Extra features for handling high call volumes</b><br/>
					PBX phone systems offer additional features for call management that allow businesses to handle high call volumes in an organized manner.
					<br/><br/>
				</p>
				<a href="pbx.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/KID-6673_blog.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Disadvantages of using a PBX Phone System</h3>
				<p class="font-italic">
					<b><h2><i class="fal fa-server"></i></h2> Infrastructure Heavy</b><br/>
					PBX phone systems are infrastructure-heavy. They require components like PBX server, physical wires, voicemail server, etc to be bought and stored on-premises
					<br/><br/>
					<b><h2><i class="fal fa-link"></i></h2> Prone to downtime</b><br/>
					They’re prone to downtime. If there’s anything wrong with the primary server, the entire phone system comes to a standstill.
					<br/><br/>
					<b><h2><i class="fal fa-rupee-sign"></i></h2> Expensive to set up</b><br/>
					They are extremely expensive to set up and maintain as compared to the alternative, cloud phone systems. Most businesses take years to break even on this investment.
					<br/><br/>
					<b><h2><i class="fal fa-phone-square-alt"></i></h2> Difficult to maintain</b><br/>
					They are difficult to maintain and offer low flexibility and control. It requires hours to add or remove a single agent and maintenance is dependant on the vendor’s support.
					<br/><br/>
					<b><h2><i class="fas fa-analytics"></i></h2> No Analytics</b><br/>
					PBX systems don’t offer the analytics and visibility a cloud phone system does. This gives businesses no insight into their communication patterns and trends, making it hard to optimize processes.
					<br/><br/>
				</p>
				<a href="pbx.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/IP-PBX-visual.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Are PBX Business Phone Systems Still Relevant in 2021?</h3>
				<p class="font-italic">
					PBX phone systems solved a lot of problems back in the day, but <b>they have now evolved beyond the old on-premise model.</b> Today, alternatives offer ease of use, better functionality, low-maintenance, and cost-efficiency which is hard to compete with.
					<br/><br/>
					While many businesses across the globe have moved on to other types of business phone systems, <b>a sizeable chunk of businesses still use PBX phone systems.</b> This is primarily because of the investments they’ve already made in their PBX infrastructure that they find hard to let go of.
					<br/><br/>
					The communication landscape has changed drastically and <b>businesses can no longer afford to be stuck in rigid and archaic infrastructure.</b> All things considered, PBX phone systems only meet the minimum requirements of business communication at present, and some might even argue against that.
				</p>
				<a href="pbx.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>Alternatives to PBX Phone Systems</h2>
			<p>Business communication needs have evolved and so have the channels that enable them. Here are three alternatives to PBX phone systems that better serve the needs of business communication today:</p>
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/1_nJ5GaVMG_jUoyojmsvHHgg.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Cloud PBX Phone Systems</h3>
				<p class="font-italic">
					Most of the PBX infrastructure is hosted on cloud, and all you need are phones. In this setup, you don’t need to buy bulky, expensive hardware. You can even route calls directly to agents’ mobile phones using cloud phone systems, enabling your agents to work remotely. This gives you the complete functionality of on-prem PBX along with a whole slew of innovative features.
				</p>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/On-Premise-VoIP.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>On-Prem VoIP Phone Systems</h3>
				<p class="font-italic">
					The infrastructure on the on-prem VoIP phone systems is similar to PBX phone systems. The difference is that all communication happens over the Internet instead of the PSTN and that you can transfer a whole lot more than just voice via these channels. These systems also offer better features.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Cloud VoIP Phone Systems.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Cloud VoIP Phone Systems</h3>
				<p class="font-italic">
					This again offers the complete functionality of on-prem VoIP phone systems, with additional features. You get the best of both worlds – no infrastructure required (except VoIP phones) and access to all the functionality of an on-prem VoIP phone system.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 70px;">
		</div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 text-center offset-lg-3 content" data-aos="fade-right">
				<a href="pbx.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
		</div>
		
		
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>Types of PBX Phone Systems</h2>
			<p>PBX phone systems exist in a few different varieties to fit just about any business need thrown at it. As business applications have migrated to the cloud, so have PBXs.</p>
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Hosted PBX.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Hosted PBX</h3>
				<p class="font-italic">
					Manage your employee’s phones all from your web browser. Simply purchase the service and phones, plug them in, and you’re done. You are free to adjust PBX features like call recording, call routing, auto attendants, hold music, and call forwarding. The best part is, you can fly through the online setup in minutes, not weeks. Since you directly manage this cloud-based PBX, all your devices are under your control.
				</p>
			</div>
        </div>

		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/onpremise-ctiserver.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>On-Premises PBX</h3>
				<p class="font-italic">
					For the upfront cost with occasional maintenance (consulting) fees, you can enjoy an on-site PBX. This feature is ideal if you have no growth plans, or if it’s cost-prohibitive to make the switch. However, instead of a complete phone system overhaul, you can just upgrade your PBX to one that is IP-ready.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/PBX SIP Trunking.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>PBX SIP Trunking</h3>
				<p class="font-italic">
					 For those with a PBX that want to take advantage of the VoIP benefits, there is an option for you. SIP Trunking provides the voice service for your company’s PBX. This multi-channel voice service is available without changing other PBX features. As your company grows, add more channels.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 70px;">
		</div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 text-center offset-lg-3 content" data-aos="fade-right">
				<a href="pbx.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
		</div>
		
		
		
		
		
		
		
		
		
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>Adoption of Cloud-Based Telephone Systems</h2>
			<p>Enterprises and small businesses alike are increasingly moving to cloud-based telephone systems. Cloud telephony is playing an important role amidst the pandemic in enabling customer communication. In fact, it has now become an important part of the business continuity plans of numerous companies.
			<br/>
			The pandemic may have been a catalyst for the shift, but this is as good a time as any to switch over to cloud telephony. Here are six reasons why cloud PBX systems are better than conventional PBX phone systems:</p>
        </div>
		
		 <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/it_professional_cloud_based_phone_system.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Adoption of Cloud-Based Telephone Systems</h3>
				<p class="font-italic">
					<b><h2><i class="fal fa-phone-alt"></i></h2> Easier to set up and maintain</b><br/>
					You can have your telephony system up and running in less than an hour if implemented via cloud telephony whereas it can take up to days to set up a traditional business phone system. Exotel takes care of the hardware and software involved, freeing up time for your core business activities.
					<br/><br/>
					<b><h2><i class="fal fa-cogs"></i></h2> Make changes/additions instantly</b><br/>
					Cloud telephony gives you more control and flexibility over your business telephony system. With Exotel, you can add/remove agents on the go whereas it requires a lot more time and effort in doing the same in a traditional setup.
					<br/><br/>
					<b><h2><i class="fal fa-file-alt"></i></h2> Gain more visibility and insights</b><br/>
					Exotel empowers you with data and allows you to have a bird’s-eye view over your department’s operations. Our detailed reports give you the insights required to improve processes and increase productivity while allowing you to accurately track each and every KPI for all your agents.
					<br/><br/>
					<b><h2><i class="fal fa-user"></i></h2> Enable your employees to work remotely</b><br/>
					Moving to the cloud means that your employees can make and receive calls from anywhere, anytime. This results in an increase in call-pickup rates and overall productivity.
					<br/><br/>
					<b><h2><i class="fal fa-cog"></i></h2> Integration with CRM/help desk software</b><br/>
					Empower your teams by integrating cloud telephony with your favourite CRM or help desk tool. This makes things convenient by enabling your agents to make and receive calls contextually, from within the dashboard.
					<br/><br/>
					<b><h2><i class="fal fa-expand-arrows"></i></h2> Better scalability</b><br/>
					Exotel grows with you and scales seamlessly to accommodate all of your business needs, in a pay-as-you-go model. This is a far cry from all the time, effort, and costs involved in scaling an on-prem telephony system.
					<br/><br/>
					As technology advances and customers’ expectations grow, companies are adopting better ways of communicating with their customers. More and more businesses are migrating to VoIP or cloud phone systems for the many advantages these systems offer.
					<br/><br/>
					PBX still retains a significant market share when it comes to business phone systems and will continue to do so for years. However, the adoption of alternatives is increasing steadily and businesses need to seriously consider all the options available before making a choice.
				</p>
				<a href="pbx.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/faq-frequently-asked-questions-vector-14450102.jpg" class="rounded  img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>FAQs?</h3>
				<p class="font-italic">
				</p>
				
				<div class="faq-list">
				<ul>
					<li data-aos="fade-up" data-aos-delay="100">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-1" class="collapsed"><b>What are the advantages of using a PBX phone system?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-1" class="collapse" data-parent=".faq-list">
							<p><b>The advantages of using a PBX phone system are:</b><br/><br/>
									1.Free internal communication<br/>
									2.Optimizes the number of phone lines requires<br/>
									3.Provides additional features for handling large call volumes</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="200">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-2" class="collapsed"><b>What is PBX?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-2" class="collapse" data-parent=".faq-list">
							<p>PBX or private branch exchange is a telecommunications device used by businesses to route all the calls made within, to, and from their phone network. A PBX connects a business’s internal phone lines to each other and to the PSTN (Public Switched Telephone Network). It has the intelligence to route incoming and outgoing calls based on pre-set rules programmed into it. Each terminating device connected to a PBX is called an “extension” and is assigned a unique (within that network) phone number.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="300">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-3" class="collapsed"><b>What are the alternatives to PBX phone systems?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-3" class="collapse" data-parent=".faq-list">
							<p><b>Business communication needs have evolved and so have the channels that enable them. Here are three alternatives to PBX phone systems that better serve the needs of business communication today:</b><br/><br/>
							<b>1.Cloud PBX Phone Systems:</b> Most of the PBX infrastructure is hosted on cloud, and all you need are phones. In this setup, you don’t need to buy bulky, expensive hardware. You can even route calls directly to agents’ mobile phones using cloud phone systems, enabling your agents to work remotely. This gives you the complete functionality of on-prem PBX along with a whole slew of innovative features.<br/>
							<b>2.On-Prem VoIP Phone Systems:</b> The infrastructure on the on-prem VoIP phone systems is similar to PBX phone systems. The difference is that all communication happens over the Internet instead of the PSTN and that you can transfer a whole lot more than just voice via these channels. These systems also offer better features.<br/>
							<b>3.Cloud VoIP Phone Systems:</b> This again offers the complete functionality of on-prem VoIP phone systems, with additional features. You get the best of both worlds - no infrastructure required (except VoIP phones) and access to all the functionality of an on-prem VoIP phone system.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="400">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-4" class="collapsed"><b>Why did Businesses Need a PBX?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-4" class="collapse" data-parent=".faq-list">
							<p><b>Before PBX came into the picture, if a business had 50 agents, they needed to buy 50 phone lines. This was undesirable due to the following reasons:</b><br/><br/>
							1.It was expensive.<br/>
							2.It led to a waste of resources. It’s highly unlikely that all 50 agents will be speaking to customers simultaneously.<br/>
							3.High costs for internal communication.<br/><br/>
							A PBX solved all these problems. It was more cost-effective than buying 50 phone connections, it optimized the number of phone lines needed - for 50 agents, businesses needed to buy only 7-10 phone lines, and internal communication became entirely free of cost.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="500">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-5" class="collapsed"><b>What are the disadvantages of using a PBX phone system?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-5" class="collapse" data-parent=".faq-list">
							<p>
							- PBX phone systems are infrastructure-heavy.<br/> <br/>

							- They’re prone to downtime. If there’s anything wrong with the primary server, everything comes to a standstill.<br/><br/>
							- They are extremely expensive to set up and maintain as compared to the alternative, cloud phone systems. Most businesses take years to break even on this investment.<br/><br/>
							- They are difficult to maintain and offer low flexibility and control.<br/><br/>
							- PBX systems don’t offer the analytics and visibility a cloud phone system does.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="600">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-6" class="collapsed"><b>What are the components of a PBX phone system?</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-6" class="collapse" data-parent=".faq-list">
							<p><b>A PBX phone system has the following components:</b><br/><br/>

							<b>- Private Branch Exchange Server:</b> This is the main component of PBX phone systems. It handles everything from call routing to voicemail.<br/><br/>

							<b>- Voicemail server:</b> This is where the recorded voice resides for automated greetings, and where all voicemail is stored.<br/><br/>

							<b>- Gateway:</b> This connects your PBX to the PSTN.<br/><br/>
							
							<b>- Analogue phones:</b> These phones are used by agents to make and receive calls. They are connected to the PBX via phone lines.<br/><br/>
							
							<b>- Physical wires:</b> These connect the analogue phones to the PBX.</p>
						</div>
					</li>
				</ul>
				</div>
			</div>
		</div>
		
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>Pricing</h2>
			<p></p>
        </div>
		
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-12 pt-0 pt-lg-0 order-2 order-lg-1 content pricing" id="pricing">
		
				<!-- ======= Pricing Section ======= -->
				<div class="container  p-0" data-aos="fade-up">
					<div class="row">

						<div class="col-lg-4 col-md-6 pb-4 pt-4" data-aos="fade-up" data-aos-delay="150">
							<div class="box featured">
								<h3>Dabbler</h3>
								<h4><sup>$</sup>200<span> / -</span></h4>
								<ul>
									<li>6 Months validity</li>
									<li>$ 80 Rental</li>
									<li>$ 120 Credits</li>
									<li>0 Exophone</li>
									<li>3 Agents</li>
									<li>Unlimited Channels</li>
									<li>Multilevel IVR</li>							
								</ul>
								<div class="btn-wrap">
								<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>

						<div class="col-lg-4 col-md-6 mt-4 mt-md-0 pb-4 pt-4" data-aos="fade-up" data-aos-delay="300">
							<div class="box">
								<span class="advanced">Most Popular</span>
								<h3>Believer</h3>
								<h4><sup>$</sup>500<span> / -</span></h4>
								<ul>
									<li>12 Months validity</li>
									<li>$ 150 Rental</li>
									<li>$ 350 Credits</li>
									<li>0 Exophones</li>
									<li>6 Agents</li>
									<li>Unlimited Channels</li>
									<li>Multilevel IVR</li>							
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>

						<div class="col-lg-4 col-md-6 mt-4 mt-lg-0 pb-4 pt-4" data-aos="fade-up" data-aos-delay="450">
							<div class="box featured">
								<h3>Influencer</h3>
								<h4><sup>$</sup>1000<span> / -</span></h4>
								<ul>
									<li>12 Months validity</li>
									<li>$ 150 Rental</li>
									<li>$ 850 Credits</li>
									<li>1 Exophones</li>
									<li>Unlimited agents</li>
									<li>Unlimited Channels</li>
									<li>Multilevel IVR</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>
						
					</div>
				</div><!-- End Pricing Section -->
				
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>All our plans come with the following features</h2>
			<p></p>
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-12 pt-4 pt-lg-0 order-2 order-lg-1 content">
				
				<div class="row" style="margin:0px;padding: 0px;">
					<div class="col-lg-3 col-12 pb-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="0">
						<ul>
							<li><i class="ri-check-double-line"></i> Call transfer</li>
							<li><i class="ri-check-double-line"></i> Auto dialer</li>
							<li><i class="ri-check-double-line"></i> Live dashboard</li>
						</ul>
					</div>
					
					<div class="col-lg-3 col-12 pb-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="100">
						<ul>
							<li><i class="ri-check-double-line"></i> Call recordings</li>
							<li><i class="ri-check-double-line"></i> Call & SMS APIs</li>
							<li><i class="ri-check-double-line"></i> Daily email reports</li>
						</ul>
					</div>
					
					<div class="col-lg-3 col-12 pb-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="200">
						<ul>
							<li><i class="ri-check-double-line"></i> Reports and analytics</li>
							<li><i class="ri-check-double-line"></i> Real-time notifications</li>
							<li><i class="ri-check-double-line"></i> Automated calls & SMS</li>
						</ul>
					</div>
					
					<div class="col-lg-3 col-12 pb-4" style="margin:0px;padding: 0px;" data-aos="fade-right" data-aos-delay="300">
						<ul>
							<li><i class="ri-check-double-line"></i> Missed call services</li>
							<li><i class="ri-check-double-line"></i> Dynamic call flows</li>
							<li><i class="ri-check-double-line"></i> Call & SMS campaigns</li>
						</ul>
					</div>
				</div>
				
			</div>
        </div>
		
	
		
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
		
		<?php include('public/ready_to_get_started.php');?> 
       
		
		
    </div>
</section><!-- End sippy Section -->

</main><!-- End #main -->



<?php include('public/footer.php');?> 

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>
</body>
</html>