<?php
include('includes/config.php');
include('includes/source.php');
//include('includes/function.php');
include('includes/preloder.php');
?>
<!DOCTYPE html>
<html>
<head>
<title>SpaceGlobalServices Software Development</title>
<link rel="stylesheet" href="assets/circle.css">
<style>
#hero .name-ok{
	visibility: hidden;
	position: relative;
}
#hero .name-ok:after {
	visibility: visible;
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	content: "Software Development"; 
}
#hero img {
	visibility: hidden;
	position: relative;
}
#hero img {
	visibility: visible;
	content: url(images/Software_Development1.png); 
}
.mar-pad{
	margin:0px!important;
	padding: 0px!important;
}
/*--------------------------------------------------------------
#software_development
--------------------------------------------------------------*/
.software_development {
	padding: 120px 0px;
}

.software_development .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.software_development .content ul {
  list-style: none;
  padding: 0;
}

.software_development .content ul li {
  padding-bottom: 10px;
}

.software_development .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.software_development .content p:last-child {
  margin-bottom: 0;
}

.software_development .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.software_development .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.software_development .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#software_development .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #software_development .animated {
    -webkit-animation: none;
    animation: none;
  }
  #software_development .software_development-img {
    text-align: center;
  }
  #software_development .software_development-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #software_development .software_development-img img {
	 width: 60%;
  }
  #software_development .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #software_development .software_development-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}








/*--------------------------------------------------------------
# Pricing
--------------------------------------------------------------*/
#software_development .pricing .box {
	 padding: 20px;
	 background: #fff;
	 text-align: center;
	 border-radius: 5px;
	 position: relative;
	 overflow: hidden;
	 box-shadow: 0px 2px 15px rgba(0, 0, 0, 0.1);
}

#software_development .pricing h3 {
	 font-weight: 400;
	 margin: -20px -20px 20px -20px;
	 padding: 20px 15px;
	 font-size: 16px;
	 font-weight: 600;
	 color: rgba(27,189,54);
	 background: #f8f8f8;
	 text-align: left;
}

#software_development .pricing h4 {
  font-size: 36px;
  color: rgba(27,189,54);
  font-weight: 600;
  font-family: "Roboto", sans-serif;
  margin-bottom: 20px;
}

#software_development .pricing h4 sup {
  font-size: 20px;
  top: -15px;
  left: -3px;
}

#software_development .pricing h4 span {
  color: #bababa;
  font-size: 16px;
  font-weight: 300;
}

#software_development .pricing ul {
  padding: 0;
  list-style: none;
  color: #444444;
  text-align: center;
  line-height: 20px;
  font-size: 14px;
}

#software_development .pricing ul li {
  padding-bottom: 16px;
}

#software_development .pricing ul i {
  color: #5846f9;
  font-size: 18px;
  padding-right: 4px;
}

#software_development .pricing ul .na {
  color: #ccc;
  text-decoration: line-through;
}

#software_development .pricing .btn-wrap {
  margin: 20px -20px -20px -20px;
  padding: 20px 15px;
  background: #f8f8f8;
  text-align: center;
}

#software_development .pricing .btn-buy {
  background: linear-gradient(42deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  display: inline-block;
  padding: 10px 35px;
  border-radius: 4px;
  color: #fff;
  transition: none;
  font-size: 15px;
  font-weight: 400;
  font-family: "Roboto", sans-serif;
  font-weight: 600;
  transition: 0.3s;
}

#software_development .pricing .btn-buy:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

#software_development .pricing .featured h3 {
  color: #fff;
  background: rgba(27,189,54);
}

#software_development .pricing .advanced {
  width: 200px;
  position: absolute;
  top: 18px;
  right: -68px;
  transform: rotate(45deg);
  z-index: 1;
  font-size: 14px;
  padding: 1px 0 3px 0;
  background: rgba(27,189,54);
  color: #fff;
}


/*--------------------------------------------------------------
# list
--------------------------------------------------------------*/
#software_development .faq-list {
	padding: 0px;
}
#software_development .faq-list ul {
	 padding: 0;
	 list-style: none;
}
#software_development .faq-list li + li {
	 margin-top: 1px;
}
#software_development .faq-list li {
	 padding: 20px;
	 background: #fff;
	 border-radius: 5px;
	 position: relative;
}
#software_development .faq-list a {
	 display: block;
	 position: relative;
	 font-family: "Roboto", sans-serif;
	 font-size: 16px;
	 line-height: 24px;
	 font-weight: 500;
	 padding: 0 30px;
	 outline: none;
	 color:rgba(27,189,54);
}
#software_development .faq-list .icon-help {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 left: 20px;
	 color: rgba(27,189,54);
}
#software_development .faq-list .icon-show, .faq .faq-list .icon-close {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 top: 0;
}
#software_development .faq-list p {
	 margin-bottom: 0;
	 padding: 10px 0 0 0;
}
#software_development .faq-list .icon-show {
	 display: none;
}
#software_development .faq-list a.collapsed {
	 color: rgba(27,189,54);
}
#software_development .faq-list a.collapsed:hover {
	 color: rgba(30,30,30);
}
#software_development .faq-list a.collapsed .icon-show {
	 display: inline-block;
}
#software_development .faq-list a.collapsed .icon-close {
	 display: none;
}
@media (max-width: 1200px) {
	.#software_development .faq-list {
		 padding: 0;
	}
}

/*--------------------------------------------------------------
# Counts
--------------------------------------------------------------*/
#software_development .counts {
 /* padding: 80px 0 60px 0;*/
}

#software_development .counts .counters i {
	color: rgba(27,189,54);
	margin-bottom: 10px;
}

#software_development .counts .counters span {
  font-size: 48px;
  display: block;
  color: #2c4964;
  font-weight: 600;
  font-family: "Poppins", sans-serif;
}

#software_development .counts .counters p {
  padding: 0;
  margin: 0 0 20px 0;
  font-size: 20px;
  color: #2c4964;
}
</style>
</head>
<body onload="mypre()">	

<!-- ======= Header ======= -->
<?php include('public/navbar.php');?>

<main id="main">

<!-- ======= software_development Section ======= -->
<section id="software_development" class="software_development">
    <div class="container">
		
		
		<div class="section-title">
          <h2>Software Development</h2>
          <p>Software development is the process of conceiving, specifying, designing, programming, documenting, testing, and bug fixing involved in creating and maintaining applications, frameworks, or other software components. </p>
        </div>
		
		<div class="row" style="margin-top: 50px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-1 order-lg-1 content" data-aos="zoom-in" data-aos-delay="150">
				<h3><small><small><small><span style="color:rgba(27,189,54)">-------</span> CUSTOM
				SOFTWARE APPLICATION SOLUTIONS</small></small></small><br/><br/>
				Getting Started<br/>
				<span style="color:rgba(27,189,54)">with Software Development</span>
				</h3>
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<p class="font-italic mt-4">
					<big>It is a process to create computer software using one or more specific programming languages that provides functionality to address particular business or personal objectives. </big>
				</p>
			</div>
			<div class="col-lg-12 pt-4 pb-4 order-2 order-lg-2 content" data-aos="fade-right">
				<hr/>
			</div>
        </div>
		
		
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 software_development-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Software-development.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Software Development?</h3>
				<p class="font-italic">
					Software development is the process programmers use to build computer programs. The process, also known as the Software Development Life Cycle (SDLC), includes several phases that provide a method for building products that meet technical specifications and user requirements.
					<br/><br/>
					The SDLC provides an international standard that software companies can use to build and improve their computer programs. It offers a defined structure for development teams to follow in the design, creation and maintenance of high-quality software. The aim of the IT <b>software development process is to build effective products within a defined budget and timeline.</b>
				</p>
				<a href="software_development.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>Key steps in the software development process</h2>
			<p>There are six major steps in the software development life cycle, including. </p>
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 software_development-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/employee-recognition-ideas.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Needs identification</h3>
				<p class="font-italic">
					Needs identification is a market research and brainstorming stage of the process. Before a firm builds software, it needs to perform extensive market research to determine the product's viability. Developers must identify the functions and services the software should provide so that its target consumers get the most out of it and find it necessary and useful. There are several ways to get this information, including feedback from potential and existing customers and surveys.
					<br/><br/>
					The IT teams and other divisions in the company must also discuss the strengths, weaknesses and opportunities of the product. Software development processes start only if the product satisfies every parameter necessarily for its success.
				</p>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 software_development-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/write-a-professional-software-requirements-specification.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Requirement analysis</h3>
				<p class="font-italic">
					Requirement analysis is the second phase in the software development life cycle. Here, stakeholders agree on the technical and user requirements and specifications of the proposed product to achieve its goals. This phase provides a detailed outline of every component, the scope, the tasks of developers and testing parameters to deliver a quality product.
					<br/><br/>
					The requirement analysis stage involves developers, users, testers, project managers and quality assurance. This is also the stage where programmers choose the software development approach such as the waterfall or V model. The team records the outcome of this stage in a Software Requirement Specification document which teams can always consult during the project implementation.
				</p>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 software_development-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Software_Development1.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Design</h3>
				<p class="font-italic">
					Design is the third stage of the software development process. Here, architects and developers draw up advanced technical specifications they need to create the software to requirements. Stakeholders will discuss factors such as risk levels, team composition, applicable technologies, time, budget, project limitations, method and architectural design.
					<br/><br/>
					The Design Specification Document (DSD) specifies the architectural design, components, communication, front-end representation and user flows of the product. This step provides a template for developers and testers and reduces the chances of flaws and delays in the finished product.
				</p>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 software_development-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/implementation3.ebf3da5a.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Development and implementation</h3>
				<p class="font-italic">
					The next stage is the development and implementation of the design parameters. Developers code based on the product specifications and requirements agreed upon in the previous stages. Following company procedures and guidelines, front-end developers build interfaces and back-ends while database administrators create relevant data in the database. The programmers also test and review each other's code.
					<br/><br/>
					Once the coding is complete, developers deploy the product to an environment in the implementation stage. This allows them to test a pilot version of the program to make performance match the requirements.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 software_development-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/287-2877074_thumb-image-website-software-testing-hd-png-download.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Testing</h3>
				<p class="font-italic">
					The testing phase checks the software for bugs and verifies its performance before delivery to users. In this stage, expert testers verify the product's functions to make sure it performs according to the requirements analysis document.
					<br/><br/>
					Testers use exploratory testing if they have experience with that software or a test script to validate the performance of individual components of the software. They notify developers of defects in the code. If developers confirm the flaws are valid, they improve the program, and the testers repeat the process until the software is free of bugs and behaves according to requirements.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 software_development-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Deployment and maintenance.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Deployment and maintenance</h3>
				<p class="font-italic">
					Once the software is defect-free, the developers can deliver it to customers. After the release of a software's production version, the IT software development company creates a maintenance team to manage issues clients encounter while using the product. Maintenance can be a hot-fix if it is a minor issue but severe software failures require an update.
				</p>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 70px;">
		</div>
		
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 text-center offset-lg-3 content" data-aos="fade-right">
				<a href="software_development.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
		</div>

		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-12 pt-4 pt-lg-0 order-2 order-lg-1 content">
				
				<div class="row" style="margin:0px;padding: 0px;">
					<div class="col-lg-3 col-6 pb-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="0">
						<div class="c100 p95 green">
							<span><i class="fal fa-integral"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>Functionality</h5>
							<p class="font-italic">
								It refers to the degree of performance of the software against its intended purpose.
							</p>
						</div>
					</div>
					
					<div class="col-lg-3 col-6 pb-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="100">
						<div class="c100 p90 green">
							<span><i class="fas fa-square"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>Reliability</h5>
							<p class="font-italic">
								A set of attribute that bear on capability of software to maintain its level of performance under the given condition for a stated period of time.
							</p>
						</div>
					</div>
					
					<div class="col-lg-3 col-6 pb-4" style="margin:0px;padding: 0px" data-aos="fade-right" data-aos-delay="200">
						<div class="c100 p98 green">
							<span><i class="fal fa-mind-share"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>Maintainability</h5>
							<p class="font-italic">
								It refers to the ease with which the modifications can be made in a software system to extend its functionality, improve its performance, or correct errors.
							</p>
						</div>
					</div>
					
					<div class="col-lg-3 col-6 pb-4" style="margin:0px;padding: 0px;" data-aos="fade-right" data-aos-delay="300">
						<div class="c100 p80 green">
							<span><i class="fal fa-location-arrow"></i></span>
							<div class="slice">
								<div class="bar"></div>
								<div class="fill"></div>
							</div>
						</div>
						<div style="display: inline-block!important">
							<h5>Portability</h5>
							<p class="font-italic">
								A set of attribute that bear on the ability of software to be transferred from one environment to another, without or minimum changes.
							</p>
						</div>
					</div>
				</div>
				
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 software_development-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/software-development-costs.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Costs?</h3>
				<p class="font-italic">
					Software development costs can greatly vary. Upfront investments may be required in licenses for the selected programming language and tools, and training costs for software developers can be high. However, there are plenty of low costs or free tools and programming languages available, and if you pick a widely used development model and pay competitive salaries, you should be able to attract good software developers who can produce great products at an economical cost.
				</p>
				<a href="contact_us.php#contactus" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
			<h2>Pricing</h2>
			<p></p>
        </div>
		
		
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-12 pt-0 pt-lg-0 order-2 order-lg-1 content pricing" id="pricing">
		
				<!-- ======= Pricing Section ======= -->
				<div class="container  p-0" data-aos="fade-up">
					<div class="row">

						<div class="col-lg-4 col-md-6 pb-4 pt-4" data-aos="fade-up" data-aos-delay="150">
							<div class="box featured">
								<h3>Basic</h3>
								<h4><sup>$</sup>200<span> / -</span></h4>
								<ul>
									<li>6 Months validity</li>
									<li>$ 80 Rental</li>
									<li>$ 120 Credits</li>
									<li>0 Exophone</li>
									<li>3 Agents</li>
									<li>Unlimited Channels</li>
									<li>Multilevel IVR</li>							
								</ul>
								<div class="btn-wrap">
								<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>

						<div class="col-lg-4 col-md-6 mt-4 mt-md-0 pb-4 pt-4" data-aos="fade-up" data-aos-delay="300">
							<div class="box">
								<!--span class="advanced">Most Popular</span-->
								<h3>Standerd</h3>
								<h4><sup>$</sup>500<span> / -</span></h4>
								<ul>
									<li>12 Months validity</li>
									<li>$ 150 Rental</li>
									<li>$ 350 Credits</li>
									<li>0 Exophones</li>
									<li>6 Agents</li>
									<li>Unlimited Channels</li>
									<li>Multilevel IVR</li>							
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>

						<div class="col-lg-4 col-md-6 mt-4 mt-lg-0 pb-4 pt-4" data-aos="fade-up" data-aos-delay="450">
							<div class="box featured">
								<h3>Premium</h3>
								<h4><sup>$</sup>1000<span> / -</span></h4>
								<ul>
									<li>12 Months validity</li>
									<li>$ 150 Rental</li>
									<li>$ 850 Credits</li>
									<li>1 Exophones</li>
									<li>Unlimited agents</li>
									<li>Unlimited Channels</li>
									<li>Multilevel IVR</li>
								</ul>
								<div class="btn-wrap">
									<a href="contact_us.php#contactus" class="btn-buy">Buy Now</a>
								</div>
							</div>
						</div>
						
					</div>
				</div><!-- End Pricing Section -->
				
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
			
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 software_development-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/f9f8b11477b2dfd4ce2f248b089a8cd1.png" class="rounded  img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Why is software development important?</h3>
				<p class="font-italic">
					<b>General Information About software development</b><br/>
					Software development is important because it helps businesses differentiate themselves and be more competitive. It can improve customer experiences, bring more innovative, feature-rich products to market faster, and make operations more efficient, safe and productive.
					<br/><br/>
					Software development is also important because it is pervasive. As IBM vice president and blogger Dibbe Edwards points out: “Software has emerged as a key differentiator in many products — from cars to washing machines to thermostats — with a growing Internet of Things connecting them.”
				</p>
				<a href="software_development.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
		</div>
		
	
		
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
		
		<?php include('public/ready_to_get_started.php');?> 
       
		
		
    </div>
</section><!-- End software_development Section -->

</main><!-- End #main -->



<?php include('public/footer.php');?> 

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>
</body>
</html>