<?php
include('includes/config.php');
include('includes/source.php');
//include('includes/function.php');
include('includes/preloder.php');
?>
<!DOCTYPE html>
<html>
<head>
<title>SpaceGlobalServices Search Engine Optimization (SEO)</title>
<link rel="stylesheet" href="assets/circle.css">
<style>
#hero .name-ok{
	visibility: hidden;
	position: relative;
}
#hero .name-ok:after {
	visibility: visible;
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	content: "Search Engine Optimization (SEO)"; 
}
#hero img {
	visibility: hidden;
	position: relative;
}
#hero img {
	visibility: visible;
	content: url(images/SEO-png.png); 
}
.mar-pad{
	margin:0px!important;
	padding: 0px!important;
}


/*--------------------------------------------------------------
#seo
--------------------------------------------------------------*/
.seo {
	padding: 120px 0px;
}

.seo .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.seo .content ul {
  list-style: none;
  padding: 0;
}

.seo .content ul li {
  padding-bottom: 10px;
}

.seo .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.seo .content p:last-child {
  margin-bottom: 0;
}

.seo .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.seo .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.seo .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#seo .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #seo .animated {
    -webkit-animation: none;
    animation: none;
  }
  #seo .seo-img {
    text-align: center;
  }
  #seo .seo-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #seo .seo-img img {
	 width: 60%;
  }
  #seo .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #seo .seo-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

/*--------------------------------------------------------------
# list
--------------------------------------------------------------*/
#seo .faq-list {
	padding: 0px;
}
#seo .faq-list ul {
	 padding: 0;
	 list-style: none;
}
#seo .faq-list li + li {
	 margin-top: 1px;
}
#seo .faq-list li {
	 padding: 20px;
	 background: #fff;
	 border-radius: 5px;
	 position: relative;
}
#seo .faq-list a {
	 display: block;
	 position: relative;
	 font-family: "Roboto", sans-serif;
	 font-size: 16px;
	 line-height: 24px;
	 font-weight: 500;
	 padding: 0 30px;
	 outline: none;
	 color:rgba(27,189,54);
}
#seo .faq-list .icon-help {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 left: 20px;
	 color: rgba(27,189,54);
}
#seo .faq-list .icon-show, .faq .faq-list .icon-close {
	 font-size: 24px;
	 position: absolute;
	 right: 0;
	 top: 0;
}
#seo .faq-list p {
	 margin-bottom: 0;
	 padding: 10px 0 0 0;
}
#seo .faq-list .icon-show {
	 display: none;
}
#seo .faq-list a.collapsed {
	 color: rgba(27,189,54);
}
#seo .faq-list a.collapsed:hover {
	 color: rgba(30,30,30);
}
#seo .faq-list a.collapsed .icon-show {
	 display: inline-block;
}
#seo .faq-list a.collapsed .icon-close {
	 display: none;
}
@media (max-width: 1200px) {
	.#seo .faq-list {
		 padding: 0;
	}
}

</style>
</head>
<body onload="mypre()">	
<!-- ======= Header ======= -->
<?php include('public/navbar.php');?>

<main id="main">

<!-- ======= seo Section ======= -->
<section id="seo" class="seo">
    <div class="container">
		
		
		<div class="section-title">
          <h2>SEO</h2>
          <p>Search engine optimization is the process of improving the quality and quantity of website traffic to a website or a web page from search engines. SEO targets unpaid traffic rather than direct traffic or paid traffic.</p>
        </div>
		
		<div class="row" style="margin-top: 50px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-1 order-lg-1 content" data-aos="zoom-in" data-aos-delay="150">
				<h3><small><small><small><span style="color:rgba(27,189,54)">-------</span> SEO SOLUTIONS</small></small></small><br/><br/>
				Getting Started<br/>
				<span style="color:rgba(27,189,54)">with Search Engine Optimization</span>
				</h3>
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<p class="font-italic mt-4">
					<big>Search engine optimization is the process of improving the quality and quantity of website traffic to a website or a web page from search engines. SEO targets unpaid traffic rather than direct traffic or paid traffic.</big>
				</p>
			</div>
			<div class="col-lg-12 pt-4 pb-4 order-2 order-lg-2 content" data-aos="fade-right">
				<hr/>
			</div>
        </div>
		
		
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 seo-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/SEO-main.jpg" class="rounded img-fluid animated" alt="" />
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Search Engine Optimization?</h3>
				<p class="font-italic">
					Any marketing that uses electronic devices to convey promotional messaging aSEO means Search Engine Optimization and is the process used to optimize a website's technical configuration, content relevance and link popularity so its pages can become easily findable, more relevant and popular towards user search queries, and as a consequence, search engines rank them better.
					<br/><br/>
					Search engines recommend SEO efforts that benefit both the user search experience and page’s ranking, by featuring content that fulfills user search needs. This includes the use of relevant keywords in titles, meta descriptions, and headlines (H1), featuring descriptive URLs with keywords rather than strings of numbers, and schema markup to specify the page's content meaning, among other SEO best practices.
				</p>
				<a href="seo.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 seo-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/What-is-SEO.jpg" class="rounded img-fluid animated" alt="" />
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>What is SEO?</h3>
				<p class="font-italic">
					SEO stands for search engine optimization, which helps your page rank higher on Google and other search engines for relevant, targeted queries - and therefore, to attract more user clicks, as they tend to click on the first result - <b>todrive more traffic to your site.</b><br/><br/>
					You can optimize your pages based on what search engines look for in a <b>website</b>, which changes as technology trends continue to evolve. And if you haven’t done so already, you can adjust your web presence to make sure it's useful and informative.<br/><br/>
					But SEO hasn't always been this way. In the early days of the internet, search engines ranked sites by how many times each site used a particular <b>keyword</b>. This led to a practice known as "keyword stuffing," and it meant that even high-quality sites could easily get buried. Now Google prioritizes quality over keyword density.<br/><br/>
					If you have a website, that’s good news, because you can invest time and talent to create a site that makes you more likely to rank highly.<br/><br/>
					To learn how, you need to understand how search engines work. We'll use Google as an example because it powers the most searches in the world.<br/><br/>
				</p>
				<a href="seo.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 seo-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/work-seo.png" class="rounded img-fluid animated" alt="" />
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>How does SEO work?</h3>
				<p class="font-italic">
					Search engines such as Google and Bing use bots to crawl pages on the web, going from site to site, collecting information about those pages and putting them in an index. Next, algorithms analyze pages in the index, taking into account hundreds of ranking factors or signals, to determine the order pages should appear in the search results for a given query.<br/><br/>
					Search ranking factors can be considered proxies for aspects of the user experience. Our Periodic Table of SEO Factors organizes the factors into six main categories and weights each based on its overall importance to SEO. For example, content quality and keyword research are key factors of content optimization, and crawlability and mobile-friendliness are important site architecture factors.<br/><br/>
					The search algorithms are designed to surface relevant, authoritative pages and provide users with an efficient search experience. Optimizing your site and content with these factors in mind can help your pages rank higher in the search results.<br/><br/>
				</p>
				<a href="seo.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 seo-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Why-SEO-is-Important-for-a-website.jpg" class="rounded img-fluid animated" alt="" />
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Why is SEO important for marketing?</h3>
				<p class="font-italic">
					SEO is a fundamental part of digital marketing because people conduct trillions of searches every year, often with commercial intent to find information about products and services. Search is often the primary source of digital traffic for brands and complements other marketing channels. Greater visibility and ranking higher in search results than your competition can have a material impact on your bottom line.<br/><br/>
					However, the search results have been evolving over the past few years to give users more direct answers and information that is more likely to keep users on the results page instead of driving them to other websites.<br/><br/>
					Also note, features like rich results and Knowledge Panels in the search results can increase visibility and provide users more information about your company directly in the results.
				</p>
				<a href="seo.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 seo-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Google-work-seo.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>How does Google work?</h3>
				<p class="font-italic">
					When you enter a search term, Google's algorithm determines which of the countless websites out there will be most relevant to you. It then lists the relevant sites taking into consideration their relevance and popularity -among other ranking factors - and shows them to you on what the industry calls a search engine results page.
				</p>
				<a href="seo.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 seo-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Crawling-seo.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Crawling</h3>
				<p class="font-italic">
					Google is constantly searching the web looking for new or updated pages, simulating the bheavior os users. It uses programs known as web crawlers, which follow links across the internet, a process also known as crawling, and report what they find to Google's servers.<br/><br/>
					That’s why it’s fundamental to make sure that your pages are accessible to be crawled and your site architecture should facilitate navigation across all site pages, by the effective usage of internal linking. <br/><br/>
					Technical SEO is the aspect of SEO that will help to effectively configure your site to optimize its crawlability. There’s a variety of SEO tools that can help you with this task.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 seo-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Indexing-seo.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Indexing</h3>
				<p class="font-italic">
					When Google's web crawlers return information about a website, a collection of internal servers analyzes each page's content to determine its topics.<br/><br/>
					If Google considers that the page information can be useful and relevant to be shown in search results, it will keep it in its index ready to be served whenever someone searches for a relevant topic.<br/><br/>
					<b>That's why its important to:</b>
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Make sure that each page is only shown through a single URL (avoiding duplicated content)</li>
					<li><i class="ri-check-double-line"></i> Use concise and relevant page titles and headings for each page</li>
					<li><i class="ri-check-double-line"></i> Feature unique, comprehensive descriptive text information in each page</li>
					<li><i class="ri-check-double-line"></i> Add alt text, or text that shows in place of images, to help Google process video and image content</li>
				</ul>
				<p class="font-italic">
					The clearer you are about the page's content, the more accurate the indexing process will be. That's why content marketing is key for SEO success.
				</p>
			</div>
        </div>
		
		
		<div class="section-title" style="margin-top: 120px;">
        </div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 seo-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/Ranking-factors-seo.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>Ranking</h3>
				<p class="font-italic">
					When someone conducts a search, Google determines which pages appear first to provide the best user experience by considering factors such as:
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> The words used in the search query</li>
					<li><i class="ri-check-double-line"></i> The user's location</li>
					<li><i class="ri-check-double-line"></i> The page's information relevance, trustworthiness, expertise and authority towards the searched terms</li>
					<li><i class="ri-check-double-line"></i> The page's link popularity</li>
					<li><i class="ri-check-double-line"></i> The pages configuration to provide a fast, reliable experience: such as its speed and mobile friendliness.</li>
				</ul>
				<p class="font-italic">
					The ongoing challenge of SEO is making sure that pages on your site perform better than all others about the same topic, taking into account the above mentioned SEO factors, so a page can continue to perform better in search results, independently of algorithm changes.
				</p>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 70px;">
		</div>
		
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 text-center offset-lg-3 content" data-aos="fade-right">
				<a href="seo.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
		</div>
		
		
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 seo-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/get_ranked_higher_on_google.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>What helps you rank higher today?</h3>
				<p class="font-italic">
					Since the 1990s, search engines have used algorithms to determine what sites should show up first on their results pages. What those algorithms prioritize, however, has changed—a lot.<br/><br/>
					Since the days of keyword stuffing, Google has been working hard to understand what makes a website relevant and informative. It applies this knowledge every few months when it releases a new update designed to rank sites more effectively.<br/><br/>
					Google still considers the usage and inclusion of the targeted keyword within the content when ranking websites, although the quality of the information matters too.<br/><br/>
					<b>Google judges quality based on:</b>
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Relevance to the search</li>
					<li><i class="ri-check-double-line"></i> Expertise, authoritativeness, and trustworthiness of the source</li>
					<li><i class="ri-check-double-line"></i> Usability of the site</li>
					<li><i class="ri-check-double-line"></i> Mobile friendliness and adaptability between browsers</li>
					<li><i class="ri-check-double-line"></i> Page load speeds</li>
				</ul>
				<p class="font-italic">
					Some of these factors are on-page, meaning that they're part of how you experience the website. Others are off-page, like other sites linking to yours. Links are seen as “votes” or endorsements by Google. Off-page elements strengthen your site’s reputation and popularity to improve its ranking.<br/><br/>
					Classifying the different areas to be optimized by whether they're on-page or off-page will help you develop an effective SEO strategy. On-page SEO and off-page SEO both help you rank more highly, but the ways to put them into practice are quite different.
				</p>
				<a href="seo.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
			
		<div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-1 seo-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/seo-basics-guide-perfectly-optimized-page.gif" class="rounded  img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>On-Page Optimization for SEO?</h3>
				<p class="font-italic">
					The best way to differentiate <b>on-page and off-page SEO</b> is by the terms themselves.<br/><br/>
					On-page SEO refers to the elements that are included on the site, technical configurations as well as content, that search engines will take into consideration, including but not limited to:
				</p>
				<ul>
					<li><i class="ri-check-double-line"></i> Title Tags</li>
					<li><i class="ri-check-double-line"></i> Meta Descriptions</li>
					<li><i class="ri-check-double-line"></i> Headings</li>
					<li><i class="ri-check-double-line"></i> URL structure</li>
					<li><i class="ri-check-double-line"></i> Main page copy</li>
					<li><i class="ri-check-double-line"></i> Image Alt descriptions</li>
					<li><i class="ri-check-double-line"></i> Load speed</li>
					<li><i class="ri-check-double-line"></i> Mobile friendliness</li>	
				</ul>
				<p class="font-italic">
					The more on-page SEO elements you address effectively, the higher your site will rank in organic searches.
				</p>
				<div class="faq-list">
				<ul>
					<li data-aos="fade-up" data-aos-delay="100">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-1" class="collapsed"><b>Title Tags</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-1" class="collapse" data-parent=".faq-list">
							<p>While Google is working to better understand the actual meaning of a page and de-emphasizing (and even punishing) aggressive and manipulative use of keywords, including the term (and related terms) that you want to rank for in your pages is still valuable. And the single most impactful place you can put your keyword is your page’s title tag.<br/><br/>
							The title tag is not your page’s primary headline. The headline you see on the page is typically an H1 (or possibly an H2) HTML element. The title tag is what you can see at the very top of your browser, and is populated by your page’s source code in a meta tag:</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="200">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-2" class="collapsed"><b>Meta Descriptions</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-2" class="collapse" data-parent=".faq-list">
							<p>While the title tag is effectively your search listing’s headline, the meta description (another meta HTML element that can be updated in your site’s code, but isn’t seen on your actual page) is effectively your site’s additional ad copy. Google takes some liberties with what they display in search results, so your meta description may not always show, but if you have a compelling description of your page that would make folks searching likely to click, you can greatly increase traffic. (Remember: showing up in search results is just the first step! You still need to get searchers to come to your site, and then actually take the action you want.)</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="300">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-3" class="collapsed"><b>Body Content</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-3" class="collapse" data-parent=".faq-list">
							<p>The actual content of your page itself is, of course, very important. Different types of pages will have different “jobs” – your cornerstone content asset that you want lots of folks to link to needs to be very different than your support content that you want to make sure your users find and get an answer from quickly. That said, Google has been increasingly favoring certain types of content, and as you build out any of the pages on your site, there are a few things to keep in mind:<br/><br/>
							- Thick & Unique Content <br/><br/>
							- Engagement<br/><br/>
							- Sharability<br/><br/>
							</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="400">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-4" class="collapsed"><b>Alt Attributes</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-4" class="collapse" data-parent=".faq-list">
							<p>How you mark up your images can impact not only the way that search engines perceive your page, but also how much search traffic from image search your site generates. An alt attribute is an HTML element that allows you to provide alternative information for an image if a user can’t view it. Your images may break over time (files get deleted, users have difficulty connecting to your site, etc.) so having a useful description of the image can be helpful from an overall usability perspective. This also gives you another opportunity – outside of your content – to help search engines understand what your page is about.<br/><br/>
							You don’t want to “keyword stuff” and cram your core keyword and every possible variation of it into your alt attribute. In fact, if it doesn’t fit naturally into the description, don’t include your target keyword here at all. Just be sure not to skip the alt attribute, and try to give a thorough, accurate description of the image (imagine you’re describing it to someone who can’t see it – that’s what it’s there for!).</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="400">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-5" class="collapsed"><b>URL Structure</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-5" class="collapse" data-parent=".faq-list">
							<p>Your site’s URL structure can be important both from a tracking perspective (you can more easily segment data in reports using a segmented, logical URL structure), and a shareability standpoint (shorter, descriptive URLs are easier to copy and paste and tend to get mistakenly cut off less frequently). Again: don’t work to cram in as many keywords as possible; create a short, descriptive URL.<br/><br/>
							Moreover: if you don’t have to, don’t change your URLs. Even if your URLs aren’t “pretty,” if you don’t feel as though they’re negatively impacting users and your business in general, don’t change them to be more keyword focused for “better SEO.” If you do have to change your URL structure, make sure to use the proper (301 permanent) type of redirect. This is a common mistake businesses make when they redesign their websites.</p>
						</div>
					</li>
					<li data-aos="fade-up" data-aos-delay="400">
						<i class="bx bx-help-circle icon-help"></i> <a data-toggle="collapse" href="#faq-list-6" class="collapsed"><b>Schema & Markup</b> <i class="bx bx-chevron-down icon-show"></i><i class="bx bx-chevron-up icon-close"></i></a>
						<div id="faq-list-6" class="collapse" data-parent=".faq-list">
							<p>Finally, once you have all of the standard on-page elements taken care of, you can consider going a step further and better helping Google (and other search engines, which also recognize schema) to understand your page.<br/><br/>
							Schema markup does not make your page show up higher in search results (it’s not a ranking factor, currently). It does give your listing some additional “real estate” in the search results, the way ad extensions do for your AdWords ads.</p>
						</div>
					</li>
				</ul>
				</div>
			</div>
		</div>
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
		
        <div class="row" style="margin-bottom: 90px;">
			<div class="col-lg-6 order-1 order-lg-2 seo-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/audience-seo.png" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>Focus on your audience</h3>
				<p class="font-italic">
					Now that you’re familiar with SEO, you can work to improve your site’s ranking and visibility. And it’s easy to get started! The more valuable your content is to your audience—and the more you optimize the more technical aspects of your site—the better your results will be.
				</p>
				<a href="seo.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
        </div>
		
		<div class="section-title" style="margin-top: 120px;">
		</div>
		
		<?php include('public/ready_to_get_started.php');?> 
       
		
		
    </div>
</section><!-- End seo Section -->

</main><!-- End #main -->



<?php include('public/footer.php');?> 

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>
</body>
</html>