<?php // 5 ?>
<!DOCTYPE html>
<html>
<head>
<style>
/*--------------------------------------------------------------
# sip
--------------------------------------------------------------*/
.sip {
	padding: 120px 0px 10px 0px;
}

.sip .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.sip .content ul {
  list-style: none;
  padding: 0;
}

.sip .content ul li {
  padding-bottom: 10px;
}

.sip .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.sip .content p:last-child {
  margin-bottom: 0;
}

.sip .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.sip .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.sip .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#sip .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #sip .animated {
    -webkit-animation: none;
    animation: none;
  }
  #sip .sip-img {
    text-align: center;
  }
  #sip .sip-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #sip .sip-img img {
	 width: 60%;
  }
  #sip .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #sip .sip-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}
</style>
</head>
<body>	
<!-- ======= sip Section ======= -->
<section id="sip" class="sip">
    <div class="container">
		
		<div class="section-title">
          <h2>Sip</h2>
          <p>Session Initiation Protocol (SIP) is a signaling protocol used for initiating, maintaining, modifying and terminating.</p>
        </div>
		
        <div class="row">
			<div class="col-lg-6 order-1 order-lg-1 sip-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/esi-ecloud-pbx.8ba5bdb.3520ebf646095fc71bd44fd1febb8411.jpg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-2 content" data-aos="fade-right">
				<h3>What Is Sip (Session Initiation Protocol)?</h3>
				<p class="font-italic">
					Session Initiation Protocol (SIP) is used to signal and control interactive communication sessions. The uses for such sessions include voice, video, chat and instant messaging, as well as interactive games and virtual reality. The SIP protocol is increasingly being used to provide Voice over IP, Presence and Instant Messaging in Next Generation Networks, and being mandated for many new applications, including 3G telephony.
					<br/><br/>
					SIP is a protocol developed primarily by the SIPCORE working group of the IETF (see the SIPCORE Charter) and is an alternative to the ITU Recommendation H.323, but is a more lightweight and general-purpose, text-based protocol based on HTTP.
					<br/><br/>
					SIP can be used to control Internet multimedia conferences, Internet telephone calls and multimedia distribution, in both the core and the periphery of the communications network.
				</p>
				<a href="sip.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
			
			<div class="col-lg-12 col-md-12 col-12 pt-4 mt-4 pt-lg-0 order-2 order-lg-2 content">
			
				<div class="row">	
					<div class="col-lg-6 col-md-12 col-12">
						<a href="sip.php#whatissip" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="150">What Is Sip (Session Initiation Protocol)<i class="icofont-long-arrow-right"></i></a>
			
						<a href="sip.php#sipworks" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="300">How Does Sip Works <i class="icofont-long-arrow-right"></i></a>
						
					</div>
					<div class="col-lg-6 col-md-12 col-12">
						<a href="sip.php#sipregistrar" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="450">What is the role of a SIP registrar <i class="icofont-long-arrow-right"></i></a>
						
						<a href="sip.php#tcporudp" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="600">Does SIP use TCP or UDP <i class="icofont-long-arrow-right"></i></a>
					</div>
				</div>
				
			</div>
        </div>

    </div>
</section><!-- End sip Section -->
</body>
</html>