<?php // 10 ?>
<!DOCTYPE html>
<html>
<head>
<style>
/*--------------------------------------------------------------
#pbx
--------------------------------------------------------------*/
.pbx {
	padding: 120px 0px 10px 0px;
}

.pbx .content h3 {
  font-weight: 600;
  font-size: 32px;
  color: #2c4964;
}

.pbx .content ul {
  list-style: none;
  padding: 0;
}

.pbx .content ul li {
  padding-bottom: 10px;
}

.pbx .content ul i {
  font-size: 20px;
  padding-right: 4px;
  color: rgba(27,189,54);
}

.pbx .content p:last-child {
  margin-bottom: 0;
}

.pbx .content .read-more {
  font-family: "Poppins", sans-serif;
  font-weight: 500;
  font-size: 16px;
  letter-spacing: 1px;
  display: inline-block;
  padding: 10px 50px 10px 28px;
  border-radius: 5px;
  transition: 0.5s;
  color: #fff;
  background: linear-gradient(45deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
  position: relative;
}

.pbx .content .read-more:hover {
  background: linear-gradient(180deg, rgba(27,189,54) 0%, rgba(30,30,30) 100%);
}

.pbx .content .read-more i {
  font-size: 22px;
  position: absolute;
  right: 20px;
  top: 12px;
}

#pbx .animated {
  animation: up-down 2s ease-in-out infinite alternate-reverse both;
}


@media (max-width: 991px) {
 
 
  #pbx .animated {
    -webkit-animation: none;
    animation: none;
  }
  #pbx .pbx-img {
    text-align: center;
  }
  #pbx .pbx-img img {
    width: 50%;
  }
}

@media (max-width: 768px) {
  
  #pbx .pbx-img img {
	 width: 60%;
  }
  #pbx .mob-set{
	  margin: 0px !important;
	  padding-left: 0px !important;
	  padding-right: 0px !important;
  }
}

@media (max-width: 575px) {
  #pbx .pbx-img img {
    width: 80%;
  }
}

@-webkit-keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}

@keyframes up-down {
  0% {
    transform: translateY(10px);
  }
  100% {
    transform: translateY(-10px);
  }
}
</style>
</head>
<body>	
<!-- ======= pbx Section ======= -->
<section id="pbx" class="pbx">
    <div class="container">
		
		<div class="section-title">
          <h2>PBX Phone System</h2>
          <p>Find out what PBX means, how it works, what problems it solves, and advantages & disadvantages of PBX phone systems (& alternatives).</p>
        </div>
		
        <div class="row">
			<div class="col-lg-6 order-1 order-lg-2 pbx-img" data-aos="zoom-in" data-aos-delay="150">
				<img src="images/pbx.jpeg" class="rounded img-fluid animated" alt="">
			</div>
			<div class="col-lg-6 pt-4 pt-lg-0 order-2 order-lg-1 content" data-aos="fade-right">
				<h3>What is PBX?</h3>
				<p class="font-italic">
					PBX or private branch exchange is a telecommunications device used by businesses to route all the calls made within, to, and from their phone network. A PBX connects a business’ internal phone lines to each other and to the PSTN (Public Switched Telephone Network).
					<br/><br/>
					It has the intelligence to route incoming and outgoing calls based on pre-set rules programmed into it. Each terminating device connected to a PBX is called an “extension” and is assigned a unique (within that network) phone number.
				</p>
				<a href="pbx.php" class="read-more">Read More <i class="icofont-long-arrow-right"></i></a>
			</div>
			
			<div class="col-lg-12 col-md-12 col-12 pt-4 mt-4 pt-lg-0 order-2 order-lg-2 content">
			
				<div class="row">	
					<div class="col-lg-6 col-md-12 col-12">
						<!--a href="pbx.php" class="read-more mb-4 w-100" data-aos="fade-right" data-aos-delay="150">What Is Sip (Session Initiation Protocol)<i class="icofont-long-arrow-right"></i></a-->
					</div>
					<div class="col-lg-6 col-md-12 col-12">
					
					</div>
				</div>
				
			</div>
        </div>

    </div>
</section><!-- End pbx Section -->
</body>
</html>